
#IFDEF __STORY_DEBUG__
	Print _constEngine_ & " " & _constBuild_ & " / Page / Interaction / Sprite Modes"
	SimpleWait ( )
#ENDIF

Declare Sub Entity_Sprite_Mode ( ByRef Entity As Story_Entity_Type )

Declare Sub Entity_Mode_Dead ( ByRef Entity As Story_Entity_Type )

Declare Sub Entity_Mode_Mad ( ByRef Entity As Story_Entity_Type )

Declare Sub Entity_Mode_Default ( ByRef Entity As Story_Entity_Type )

Sub Entity_Sprite_Mode ( ByRef Entity As Story_Entity_Type )
	
	Dim As String Subject = Entity.Raw
	
	'Entity_Destroy ( Entity )
	'Entity = Entity_Create ( Subject )

	Dim As FB.Image Ptr Temp
	
	Dim As Long p_R = 0, p_G = 0, p_B = 0, p_I = 0, p_A = 0, p_X = 0, p_Y = 0, p_V = 0
	
	With Entity
	
		If Is_File ( _constIncPath_ & Gamepack.Root & Gamepack.Pack & "\Assets\Sprites\" & .Element & "\" & .ID & ".png" ) Then
		
			Select Case LCase ( .Mode )
			Case "dead"
				Entity_Mode_Dead ( Entity )
			
			Case "mad"
				Entity_Mode_Mad ( Entity )
			
			Case Else
				Entity_Mode_Default ( Entity )
			
			End Select

		Else
	
			If .Sprite <> 0 Then
				.Sprite = ImageDestroy2 ( .Sprite )
		
			End If
		
		End If
	
	End With
		
End Sub

Sub Entity_Mode_Dead ( ByRef Entity As Story_Entity_Type )
	
	Dim As String Subject = Entity.Raw
	
	'Entity_Destroy ( Entity )
	'Entity = Entity_Create ( Subject )

	Dim As FB.Image Ptr Temp
	
	Dim As Long p_R = 0, p_G = 0, p_B = 0, p_I = 0, p_A = 0, p_X = 0, p_Y = 0, p_V = 0
	
	With Entity
			
		Temp = LoadRGBAFile ( _constIncPathStr_ & Gamepack.Root & Gamepack.Pack & "\Assets\Sprites\" & .Element & "\" & .ID & ".png" ) 
		
		.Sprite = ImageCreate( Temp -> Width, Temp -> Height, RGBA ( 0, 0, 0, 0 ), 32 )
		
		Gfx_Buffer_Fill ( Temp, 1, 1, Temp -> Width \ 8 + 1, Temp -> Height \ 8 + 1 )
		
		Put .Sprite, ( 0, 0 ), Temp, Alpha

		'IF .Sprite <> 0 Then .Sprite = ImageDestroy2 ( .Sprite )
	
		IF Temp <> 0 Then Temp = ImageDestroy2 ( Temp )
	
	End With
	
End Sub
		
Sub Entity_Mode_Mad ( ByRef Entity As Story_Entity_Type )
	
	Dim As String Subject = Entity.Raw
	
	'Entity_Destroy ( Entity )
	'Entity = Entity_Create ( Subject )

	Dim As FB.Image Ptr Temp
	
	Dim As Long p_R = 0, p_G = 0, p_B = 0, p_I = 0, p_A = 0, p_X = 0, p_Y = 0, p_V = 0
	
	With Entity

		Temp = LoadRGBAFile ( _constIncPathStr_ & Gamepack.Root & Gamepack.Pack & "\Assets\Sprites\" & .Element & "\" & .ID & ".png" ) 
			
		.Sprite = ImageDestroy2 ( .Sprite )
		.Sprite = ImageCreate ( Temp -> Width, Temp -> Height, RGBA ( 0, 0, 0, 0 ), 32 )
		
		For p_Y = 0 To Temp -> Height - 1 Step 1
		For p_X = 0 To Temp -> Width - 1 Step 1
				
			p_V = Point( p_X, P_Y, Temp )
				
			p_R = RGBAr( p_V ) * 0.30 * 0.5 + RGBAr( p_V ) * 0.5
			p_G = RGBAg( p_V ) * 0.59 * 0.5 + RGBAg( p_V ) * 0.5
			p_B = RGBAb( p_V ) * 0.11 * 0.5 + RGBAb( p_V ) * 0.5
				
			p_A = RGBAa( p_V )

			p_I = ( p_R + p_G + p_B ) '/ 414
					
			PSet .Sprite, ( p_X, p_Y ), RGBA ( p_I, 0, 0, p_A )
			
		Next p_X
		Next p_Y
				
		'Put .Sprite, ( 0, 0 ), Temp, Alpha

		'IF .Sprite <> 0 Then .Sprite = ImageDestroy2 ( .Sprite )
	
		IF Temp <> 0 Then Temp = ImageDestroy2 ( Temp )
	
	End With
	
End Sub

Sub Entity_Mode_Default ( ByRef Entity As Story_Entity_Type )
	
	Dim As String Subject = Entity.Raw
	
	'Entity_Destroy ( Entity )
	'Entity = Entity_Create ( Subject )

	Dim As FB.Image Ptr Temp
	
	Dim As Long p_R = 0, p_G = 0, p_B = 0, p_I = 0, p_A = 0, p_X = 0, p_Y = 0, p_V = 0
	
	With Entity

		Temp = LoadRGBAFile ( _constIncPathStr_ & Gamepack.Root & Gamepack.Pack & "\Assets\Sprites\" & .Element & "\" & .ID & ".png" ) 
		
		.Sprite = ImageCreate( Temp -> Width, Temp -> Height, RGBA ( 0, 0, 0, 0 ), 32 )
			
		Put .Sprite, ( 0, 0 ), Temp, Alpha

		'IF .Sprite <> 0 Then .Sprite = ImageDestroy2 ( .Sprite )
	
		IF Temp <> 0 Then Temp = ImageDestroy2 ( Temp )
	
	End With
	
End Sub